/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

public interface CqnSelectListItem extends CqnToken {

	@Deprecated
	default String displayName() {
		throw new UnsupportedOperationException();
	}

	@Deprecated
	default Optional<String> alias() {
		return Optional.empty();
	}

	default CqnToken token() {
		return this;
	}

	default boolean isValue() {
		return false;
	}

	default boolean isSelectList() {
		return false;
	}

	default boolean isStar() {
		return false;
	}

	default CqnSelectListValue asValue() {
		throw new ClassCastException("Cannot cast to CqnSelectListValue");
	}

	default CqnSelectList asSelectList() {
		throw new ClassCastException("Cannot cast to CqnSelectList");
	}

	default Stream<CqnSelectListItem> unfold(
			Function<List<? extends CqnReference.Segment>, Stream<String>> pathToElements) {
		return Stream.of(this);
	}

}
