/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Optional;

public interface CqnSelectListValue extends CqnSelectListItem {

	CqnValue value();

	String displayName();

	Optional<String> alias();

	@Override
	default boolean isValue() {
		return true;
	}

	@Override
	default CqnSelectListValue asValue() {
		return this;
	}

	@Override
	default void accept(CqnVisitor visitor) {
		value().accept(visitor);

		visitor.visit(this);
	}

}
