/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Locale;

public interface CqnSortSpecification extends CqnToken {

	CqnSelectListValue item();

	Order order();

	public enum Order {
		ASC, DESC;

		@Override
		public String toString() {
			return name().toLowerCase(Locale.US);
		}
	}

	default void accept(CqnVisitor visitor) {
		visitor.visit(this);
	}
}
