/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

public interface CqnSource {

	/**
	 * Returns {@code true} if this is a {@link CqnStructuredTypeRef}.
	 * 
	 * @return {@code true} if this is a structured type reference, otherwise
	 *         {@code false}
	 */
	default boolean isRef() {
		return false;
	}

	/**
	 * Returns {@code true} if this is a {@link CqnSelect} statement.
	 * 
	 * @return {@code true} if this is a select statement, otherwise {@code false}
	 */
	default boolean isSelect() {
		return false;
	}

	/**
	 * Returns {@code true} if this is a {@link CqnJoin}.
	 * 
	 * @return {@code true} if this is a join, otherwise {@code false}
	 */
	default boolean isJoin() {
		return false;
	}

	/**
	 * Returns {@code true} if this is a {@link CqnSelect} statement.
	 * 
	 * @return {@code true} if this is a select statement, otherwise {@code false}
	 * @deprecated instead use {@link CqnSource#isSelect}
	 */
	@Deprecated
	default boolean isQuery() {
		return isSelect();
	}

	/**
	 * Casts this CQN source to {@code CqnSelect}.
	 * 
	 * @throws ClassCastException if this CQN source is not a select
	 * @return this CQN source as a CqnSelect
	 */
	default CqnStructuredTypeRef asRef() {
		throw new ClassCastException("Cannot cast to CqnStructuredTypeRef");
	}

	/**
	 * Casts this CQN source to a {@code CqnSelect}.
	 * 
	 * @throws ClassCastException if this CQN source is not a select
	 * @return this CQN source as a CqnSelect
	 */
	default CqnSelect asSelect() {
		throw new ClassCastException("Cannot cast to CqnSelect");
	}

	/**
	 * Casts this CQN source to a {@code CqnJoin}.
	 * 
	 * @throws ClassCastException if this CQN source is not a join
	 * @return this CQN source as a CqnJoin
	 */
	default CqnJoin asJoin() {
		throw new ClassCastException("Cannot cast to CqnJoin");
	}

	/**
	 * Casts this CQN source to a {@code CqnSelect}.
	 * 
	 * @throws ClassCastException if this CQN source is not a select
	 * @return this source as a CqnSelect
	 * @deprecated instead use {@link CqnSource#asSelect}
	 */
	default CqnSelect asQuery() {
		return asSelect();
	}

	void accept(CqnVisitor visitor);

}
