/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public interface CqnUpdate extends CqnStatement {

	Map<String, Object> data();

	List<Map<String, Object>> entries();

	Optional<CqnPredicate> where();

	Stream<String> elements();

	@Override
	default boolean isUpdate() {
		return true;
	}

	@Override
	default CqnUpdate asUpdate() {
		return this;
	}

	default void accept(CqnVisitor visitor) {
		ref().accept(visitor);
		where().ifPresent(w -> w.accept(visitor));

		visitor.visit(this);
	}

}
