/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

public interface CqnVisitor {

	default void visit(CqnFunc func) {
	}

	default void visit(CqnStructuredTypeRef typeRef) {
	}

	default void visit(CqnElementRef elementRef) {
	}

	default void visit(CqnPlain plain) {
	}

	default void visit(CqnReference.Segment seg) {
	}

	default void visit(CqnStar star) {
		visit((CqnSelectListItem) star);
	}

	default void visit(CqnSelectListValue slv) {
		visit((CqnSelectListItem) slv);
	}

	default void visit(CqnSelectListItem sli) {
	}

	default void visit(CqnSortSpecification sortSpec) {
	}

	default void visit(CqnExpression expr) {
	}

	default void visit(CqnXpr xpr) {
	}

	default void visit(CqnPredicate pred) {
	}

	default void visit(CqnComparisonPredicate comparison) {
	}

	default void visit(CqnSearchPredicate search) {
	}

	default void visit(CqnConnectivePredicate connective) {
	}

	default void visit(CqnInPredicate in) {
	}

	default void visit(CqnNegation neg) {
	}

	default void visit(CqnSelect select) {
	}

	default void visit(CqnLiteral<?> literal) {
	}

	default void visit(CqnContainmentTest test) {
		visit((CqnFunc) test);
	}

	default void visit(CqnStringLiteral string) {
		visit((CqnLiteral<?>) string);
	}

	default void visit(CqnBooleanLiteral bool) {
		visit((CqnLiteral<?>) bool);
	}

	default void visit(CqnNumericLiteral<?> number) {
		visit((CqnLiteral<?>) number);
	}

	default void visit(CqnTemporalLiteral<?> temporal) {
		visit((CqnLiteral<?>) temporal);
	}

	default void visit(CqnNullValue nil) {
	}

	default void visit(CqnParameter param) {
	}

	default void visit(CqnInline inline) {
	}

	default void visit(CqnExpand expand) {
	}

	default void visit(CqnLimit limit) {
	}

	default void visit(CqnInsert insert) {
	}

	default void visit(CqnUpsert upsert) {
	}

	default void visit(CqnUpdate update) {
	}

	default void visit(CqnDelete delete) {
	}

	default void visit(CqnSubQuery query) {
	}

}
