/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Map;

import com.sap.cds.ql.cqn.CqnReference.Segment;
import com.sap.cds.reflect.CdsEntity;

/**
 * Contains information on a {@link Segment} of a {@link CqnStructuredTypeRef}
 */
public interface ResolvedSegment {

	/**
	 * Returns the unmodified {@link Segment}.
	 *
	 * @return a Segment
	 */
	CqnReference.Segment segment();

	/**
	 * Returns the {@link CdsEntity} that is targeted by the {@link Segment}.
	 *
	 * @return a {@code CdsEntity}
	 */
	CdsEntity entity();

	/**
	 * Returns the element name to value mapping for the key elements of the
	 * {@link CdsEntity} that is targeted by the {@link Segment}.
	 * 
	 * Extracts the key values, i.e. the values of the key elements to the entity
	 * targeted by this segment, from this segment's filter condition. If the filter
	 * condition does not uniquely restrict a key element to a particular value, the
	 * element's name is mapped to {@code null}.
	 *
	 * @return a map relating key element names to key values
	 */
	Map<String, Object> keys();
}
