/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

import java.util.function.Supplier;

public class CdsDefinitionNotFoundException extends CdsReflectiveOperationException {

	private static final long serialVersionUID = 1L;

	public CdsDefinitionNotFoundException(Throwable e) {
		super(e);
	}

	public CdsDefinitionNotFoundException(String message) {
		super(message);
	}

	public CdsDefinitionNotFoundException(String message, Throwable e) {
		super(message, e);
	}

	static Supplier<CdsDefinitionNotFoundException> notFound(String type, String qualifiedName) {
		return notFound(String.format("Cannot find %s %s", type, qualifiedName));
	}

	static Supplier<CdsDefinitionNotFoundException> notFound(String type, String name, String context) {
		return notFound(String.format("Cannot find %s %s in %s", type, name, context));
	}

	static Supplier<CdsDefinitionNotFoundException> notFound(String message) {
		return () -> new CdsDefinitionNotFoundException(message);
	}

}
