/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

import java.util.Optional;
import java.util.stream.Stream;

public interface CdsEvent extends CdsDefinition {

	/**
	 * Get a {@link CdsElement} by name.
	 * 
	 * @param name the name of the {@code CdsElement}
	 * @return the {@code CdsElement} with the given name
	 * @throws CdsElementNotFoundException if there is no {@code CdsElement} with
	 *                                     the given name
	 */
	CdsElement getElement(String name);

	/**
	 * Returns an {@link Optional} wrapping a {@link CdsElement}.
	 * 
	 * @param name the name of the {@code CdsElement}
	 * @return an {@code Optional} describing the {@code CdsElement} with the given
	 *         name, or an empty {@code Optional} if there is no {@code CdsElement}
	 *         with this name
	 */
	Optional<CdsElement> findElement(String name);

	/**
	 * Returns a sequential {@code Stream} over all {@link CdsElement CdsElement(s)}
	 * in this event.
	 *
	 * @return a sequential {@code Stream} over the {@code CdsElement(s)}
	 */
	Stream<CdsElement> elements();

	@Override
	default void accept(CdsVisitor visitor) {
		elements().forEach(e -> e.accept(visitor));

		visitor.visit(this);
	}

}
