/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

import java.util.stream.Stream;

public interface CdsFunction extends CdsDefinition {

	/**
	 * Returns a sequential {@code Stream} over the {@link CdsParameter
	 * CdsParameter(s)} of this {@code CdsFunction}.
	 *
	 * @return a sequential {@code Stream} over the {@code CdsParameter(s)}
	 */
	Stream<CdsParameter> parameters();

	/**
	 * Returns the return type of this {@code CdsFunction}.
	 * 
	 * @return the return type of this function, not {@code null}
	 */
	CdsType getReturnType();

	@Override
	default void accept(CdsVisitor visitor) {
		parameters().forEach(e -> e.accept(visitor));

		visitor.visit(this);
	}

}
