/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

public interface CdsParameter extends CdsAnnotatable {

	/**
	 * Returns the name of this {@code CdsParameter}.
	 * 
	 * @return the name of this parameter, not {@code null}
	 */
	String getName();

	/**
	 * Returns the type of this {@code CdsParameter}.
	 * 
	 * @return the type of this parameter, not {@code null}
	 */
	CdsType getType();

	/**
	 * Accepts a {@link CdsVisitor} visiting this type.
	 * 
	 * @param visitor the {@code CdsVisitor}
	 */
	default void accept(CdsVisitor visitor) {
		visitor.visit(this);
	}

}
