/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

import java.util.Optional;

public interface CdsSimpleType extends CdsType {

	/**
	 * Returns the {@link CdsBaseType} of this {@code CdsSimpleType} definition.
	 * 
	 * @return the {@code CdsBaseType} of this simple type definition, not
	 *         {@code null}
	 */
	CdsBaseType getType();

	/**
	 * Returns the Java type of this {@code CdsSimpleType} definition.
	 * 
	 * @return the Java type of this simple type definition, not {@code null}
	 */
	Class<?> getJavaType();

	/**
	 * Returns an {@link Optional} wrapping the default value of this
	 * {@code CdsSimpleType}.
	 * 
	 * @return an {@code Optional} describing the default value of this simple type,
	 *         or an empty {@code Optional} if there is no default value
	 */
	Optional<Object> defaultValue();

	/**
	 * Returns the property for the given key.
	 * 
	 * @param          <T> the expected type of the property
	 * @param property the name of the property
	 * @return the value of the property or {@code null} if there is no property
	 *         with the given name
	 */
	<T> T get(String property);

	@Override
	default boolean isSimple() {
		return true;
	}

	@Override
	default String getQualifiedName() {
		return getType().toString();
	}

	@Override
	default void accept(CdsVisitor visitor) {
		visitor.visit(this);
	}

}
