/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

public interface CdsType extends CdsDefinition {

	/**
	 * Returns {@code true} if this is a simple type.
	 * 
	 * @return {@code true} if this is a simple type, otherwise {@code false}
	 */
	default boolean isSimple() {
		return false;
	}

	/**
	 * Returns {@code true} if this is a structured type.
	 * 
	 * @return {@code true} if this is a structured type, otherwise {@code false}
	 */
	default boolean isStructured() {
		return false;
	}

	/**
	 * Returns {@code true} if this is an association type.
	 * 
	 * @return {@code true} if this is an association type, otherwise {@code false}
	 */
	default boolean isAssociation() {
		return false;
	}

	/**
	 * Returns {@code true} if this is an enum type.
	 * 
	 * @return {@code true} if this is an enum type, otherwise {@code false}
	 */
	default boolean isEnum() {
		return false;
	}

	/**
	 * Returns {@code true} if this is an arrayed type.
	 * 
	 * @return {@code true} if this is an arrayed type, otherwise {@code false}
	 */
	default boolean isArrayed() {
		return false;
	}

	/**
	 * Casts this type to the given {@code type}.
	 * 
	 * @param <T>  the return type
	 * @param type the subtype of {@code CdsType} to cast to
	 * @return this type casted to the given {@code type} class
	 */
	@SuppressWarnings("unchecked")
	default <T extends CdsType> T as(Class<T> type) {
		return (T) this;
	}

	/**
	 * Returns {@code true} if this is a simple type with a given base type.
	 * 
	 * @param baseType the base type
	 * 
	 * @return {@code true} if this is a simple type with a given base type,
	 *         otherwise {@code false}
	 */
	default boolean isSimpleType(CdsBaseType baseType) {
		return false;
	}

}
