/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsVisitor;
import java.util.function.Predicate;

public interface CdsDefinition
extends CdsAnnotatable {
    public void accept(CdsVisitor var1);

    public String getQualifiedName();

    default public String getQualifier() {
        String qualifiedName = this.getQualifiedName();
        int lastDotPos = qualifiedName.lastIndexOf(46);
        if (lastDotPos >= 0) {
            return qualifiedName.substring(0, lastDotPos);
        }
        return "";
    }

    default public String getName() {
        String qualifiedName = this.getQualifiedName();
        int lastDotPos = qualifiedName.lastIndexOf(46);
        if (lastDotPos >= 0 && lastDotPos + 1 < qualifiedName.length()) {
            return qualifiedName.substring(lastDotPos + 1);
        }
        return qualifiedName;
    }

    public static Predicate<CdsDefinition> byNamespace(String namespace) {
        if (namespace == null || namespace.isEmpty()) {
            return d -> true;
        }
        return d -> d.getQualifiedName().startsWith(namespace + ".");
    }
}

