/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql;

import com.sap.cds.ql.BooleanFunction;
import com.sap.cds.ql.CDS;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.FunctionCall;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Parameter;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.RefSegment;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnModifier;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStar;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface CQL {
    public static Predicate copy(CqnPredicate pred) {
        return CDS.QL.builder.copy(pred);
    }

    public static Predicate copy(CqnPredicate pred, CqnModifier modifier) {
        return CDS.QL.builder.copy(pred, modifier);
    }

    public static <S extends CqnStatement> S copy(S statement) {
        return (S)CDS.QL.builder.copy(statement);
    }

    public static <S extends CqnStatement> S copy(S statement, CqnModifier modifier) {
        return (S)CDS.QL.builder.copy(statement, modifier);
    }

    public static <T> FunctionCall<T> func(String name, CqnValue ... args) {
        return CQL.func(name, Arrays.asList(args));
    }

    public static <T> FunctionCall<T> func(String name, List<? extends CqnValue> args) {
        return CDS.QL.create.func(name, args);
    }

    public static BooleanFunction booleanFunc(String name, List<? extends CqnValue> args) {
        return CDS.QL.create.booleanFunc(name, args);
    }

    public static <T> Literal<T> literal(T value) {
        return CDS.QL.create.literal(value);
    }

    public static Predicate not(CqnPredicate predicate) {
        return CDS.QL.create.not(predicate);
    }

    public static Predicate and(CqnPredicate p1, CqnPredicate p2) {
        return CQL.and(Arrays.asList(p1, p2));
    }

    public static Predicate or(CqnPredicate p1, CqnPredicate p2) {
        return CQL.or(Arrays.asList(p1, p2));
    }

    public static Predicate and(Iterable<? extends CqnPredicate> predicates) {
        return CQL.connect(CqnConnectivePredicate.Operator.AND, predicates);
    }

    public static Predicate or(Iterable<? extends CqnPredicate> predicates) {
        return CQL.connect(CqnConnectivePredicate.Operator.OR, predicates);
    }

    public static Predicate connect(CqnConnectivePredicate.Operator operator, Iterable<? extends CqnPredicate> predicates) {
        return CDS.QL.create.connect(operator, predicates);
    }

    @Deprecated
    public static <T> Parameter<T> param() {
        return CDS.QL.create.param();
    }

    public static <T> Parameter<T> param(int index) {
        return CQL.param(String.valueOf(index));
    }

    public static <T> Parameter<T> param(String name) {
        return CDS.QL.create.param(name);
    }

    public static Value<?> plain(String value) {
        return CDS.QL.create.plain(value);
    }

    public static Value<Long> count() {
        return CQL.func("COUNT", new CqnValue[0]).type(Long.class);
    }

    public static Value<Long> count(CqnElementRef element) {
        return CQL.func("COUNT", element).type(Long.class);
    }

    public static <T> Value<T> min(CqnValue value) {
        return CQL.func("min", value);
    }

    public static <T> Value<T> max(CqnValue value) {
        return CQL.func("max", value);
    }

    public static Value<Number> sum(CqnValue value) {
        return CQL.func("sum", value);
    }

    public static Value<Number> average(CqnValue value) {
        return CQL.func("avg", value);
    }

    public static Value<Long> countDistinct(CqnValue value) {
        return CDS.QL.create.countDistinct(value);
    }

    public static Value<String> toLower(Value<String> val) {
        return CDS.QL.create.toLower(val);
    }

    public static Value<String> toLower(String val) {
        return CDS.QL.create.toLower(CQL.literal(val));
    }

    public static Value<String> toUpper(Value<String> val) {
        return CDS.QL.create.toUpper(val);
    }

    public static Value<String> toUpper(String val) {
        return CDS.QL.create.toUpper(CQL.literal(val));
    }

    public static StructuredType<?> entity(String qualifiedName) {
        return CDS.QL.create.entity(qualifiedName);
    }

    public static StructuredType<?> to(String path) {
        return CDS.QL.create.to(path);
    }

    public static StructuredType<?> to(List<? extends CqnReference.Segment> segments) {
        return CDS.QL.create.to(segments);
    }

    public static <T> ElementRef<T> get(String path) {
        return CDS.QL.create.get(path);
    }

    public static <T> ElementRef<T> get(List<? extends CqnReference.Segment> segments) {
        return CDS.QL.create.get(segments);
    }

    public static RefSegment refSegment(String id) {
        return CDS.QL.create.refSegment(id);
    }

    public static List<RefSegment> refSegments(List<String> segmentIds) {
        return CDS.QL.create.refSegments(segmentIds);
    }

    public static Value<Number> expression(CqnValue left, CqnArithmeticExpression.Operator op, CqnValue right) {
        return CDS.QL.create.expression(left, op, right);
    }

    public static Predicate comparison(CqnValue lhs, CqnComparisonPredicate.Operator op, CqnValue rhs) {
        return CDS.QL.create.comparison(lhs, op, rhs);
    }

    public static Predicate in(CqnValue lhs, Collection<? extends CqnValue> values) {
        return CDS.QL.create.in(lhs, values);
    }

    public static Predicate search(String term) {
        return CDS.QL.create.search(term);
    }

    public static Predicate exists(CqnSelect subQuery) {
        return CDS.QL.create.exists(subQuery);
    }

    public static Value<Instant> now() {
        return CDS.QL.create.now().type(Instant.class);
    }

    public static Value<Instant> validFrom() {
        return CDS.QL.create.validFrom().type(Instant.class);
    }

    public static Value<Instant> validTo() {
        return CDS.QL.create.validTo().type(Instant.class);
    }

    public static Value<String> userLocale() {
        return CDS.QL.create.userLocale().type(String.class);
    }

    public static Value<String> userId() {
        return CDS.QL.create.userId().type(String.class);
    }

    public static CqnStar star() {
        return CqnStar.star();
    }

    public static CqnToken list(List<? extends CqnValue> values) {
        return CDS.QL.create.list(values);
    }

    public static Predicate matching(Map<String, ?> elementToValueMap) {
        return CDS.QL.builder.matching(elementToValueMap);
    }
}

