/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.cqn;

import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Limit;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public interface CqnModifier {
    default public Value<?> ref(ElementRef<?> ref) {
        return ref;
    }

    default public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
        return ref;
    }

    default public Value<?> literal(Object value, String cdsType) {
        return CQL.literal(value).type(cdsType);
    }

    default public Value<?> literal(String val, String cdsType) {
        return this.literal((Object)val, cdsType);
    }

    default public Value<?> literal(Number number, String cdsType) {
        return this.literal((Object)number, cdsType);
    }

    default public Value<?> literal(Boolean bool, String cdsType) {
        return this.literal((Object)bool, cdsType);
    }

    default public Value<?> literal(Temporal temporal, String cdsType) {
        return this.literal((Object)temporal, cdsType);
    }

    default public Value<?> parameter(String name, String cdsType) {
        return CQL.param(name).type(cdsType);
    }

    default public Value<?> plain(String plain, String cdsType) {
        return CQL.plain(plain).type(cdsType);
    }

    default public Value<?> expression(Value<Number> left, CqnArithmeticExpression.Operator op, Value<Number> right, String cdsType) {
        return CQL.expression(left, op, right).type(cdsType);
    }

    default public Value<?> function(String name, List<Value<?>> args, String cdsType) {
        return CQL.func(name, args).type(cdsType);
    }

    default public Predicate booleanFunction(String name, List<Value<?>> args) {
        return CQL.booleanFunc(name, args);
    }

    default public CqnToken list(List<Value<?>> args) {
        return CQL.list(args);
    }

    default public Predicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
        return CQL.comparison(lhs, op, rhs);
    }

    default public Predicate in(Value<?> value, Collection<Value<?>> list) {
        return CQL.in(value, list);
    }

    default public Predicate connective(CqnConnectivePredicate.Operator op, List<Predicate> predicates) {
        if (op == CqnConnectivePredicate.Operator.AND) {
            return CQL.and(predicates);
        }
        return CQL.or(predicates);
    }

    default public Predicate negation(Predicate p) {
        return CQL.not(p);
    }

    default public Predicate search(String term) {
        return CQL.search(term);
    }

    default public Predicate exists(Select<?> subQuery) {
        return CQL.exists(subQuery);
    }

    default public CqnSelectListItem selectListItem(Value<?> value, String alias) {
        return value.as(alias);
    }

    default public CqnSelectListItem selectAll() {
        return CQL.star();
    }

    default public CqnSelectListItem inline(StructuredTypeRef ref, List<CqnSelectListItem> items) {
        return CQL.to(ref.segments()).inline((Iterable<CqnSelectListItem>)items);
    }

    default public CqnSelectListItem expand(StructuredTypeRef ref, List<CqnSelectListItem> items, List<CqnSortSpecification> orderBy, CqnLimit limit) {
        Expand<?> expand = CQL.to(ref.segments()).expand((Iterable<CqnSelectListItem>)items).orderBy(orderBy);
        if (limit != null) {
            expand.limit(limit.top(), limit.skip());
        }
        return expand;
    }

    default public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
        return items;
    }

    default public Set<String> excluding(Set<String> excluding) {
        return excluding;
    }

    default public boolean distinct(boolean distinct) {
        return distinct;
    }

    default public boolean inlineCount(boolean inlineCount) {
        return inlineCount;
    }

    default public Predicate where(Predicate where) {
        return where;
    }

    default public Predicate search(Predicate search) {
        return search;
    }

    default public Set<String> searchableElements(Set<String> searchableElements) {
        return searchableElements;
    }

    default public List<CqnSelectListItem> groupBy(List<CqnSelectListItem> groupBy) {
        return groupBy;
    }

    default public Predicate having(Predicate having) {
        return having;
    }

    default public List<CqnSortSpecification> orderBy(List<CqnSortSpecification> orderBy) {
        return orderBy;
    }

    default public CqnLimit limit(Limit limit) {
        return limit;
    }
}

