/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect;

import com.sap.cds.CdsException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;

public enum CdsBaseType {
    UUID("cds.UUID", String.class),
    BOOLEAN("cds.Boolean", Boolean.class),
    INTEGER("cds.Integer", Integer.class),
    INTEGER64("cds.Integer64", Long.class),
    DECIMAL("cds.Decimal", BigDecimal.class),
    DECIMAL_FLOAT("cds.DecimalFloat", BigDecimal.class),
    DOUBLE("cds.Double", Double.class),
    DATE("cds.Date", LocalDate.class),
    TIME("cds.Time", LocalTime.class),
    DATETIME("cds.DateTime", Instant.class),
    TIMESTAMP("cds.Timestamp", Instant.class),
    STRING("cds.String", String.class),
    BINARY("cds.Binary", byte[].class),
    LARGE_STRING("cds.LargeString", String.class),
    LARGE_BINARY("cds.LargeBinary", byte[].class),
    HANA_SMALLINT("cds.hana.SMALLINT", Short.class),
    HANA_TINYINT("cds.hana.TINYINT", Short.class),
    HANA_SMALLDECIMAL("cds.hana.SMALLDECIMAL", BigDecimal.class),
    HANA_REAL("cds.hana.REAL", Float.class),
    HANA_CHAR("cds.hana.CHAR", String.class),
    HANA_NCHAR("cds.hana.NCHAR", String.class),
    HANA_VARCHAR("cds.hana.VARCHAR", String.class),
    HANA_CLOB("cds.hana.CLOB", String.class),
    HANA_BINARY("cds.hana.BINARY", byte[].class);

    private final String cdsName;
    private final Class<?> javaType;

    private CdsBaseType(String cdsName, Class<?> javaType) {
        this.cdsName = cdsName;
        this.javaType = javaType;
    }

    public String cdsName() {
        return this.cdsName;
    }

    public Class<?> javaType() {
        return this.javaType;
    }

    public String toString() {
        return this.cdsName;
    }

    public static CdsBaseType cdsType(String cdsType) {
        switch (cdsType) {
            case "cds.Boolean": {
                return BOOLEAN;
            }
            case "cds.UUID": {
                return UUID;
            }
            case "cds.Integer": {
                return INTEGER;
            }
            case "cds.Integer64": {
                return INTEGER64;
            }
            case "cds.Decimal": {
                return DECIMAL;
            }
            case "cds.DecimalFloat": {
                return DECIMAL_FLOAT;
            }
            case "cds.Double": {
                return DOUBLE;
            }
            case "cds.Date": {
                return DATE;
            }
            case "cds.Time": {
                return TIME;
            }
            case "cds.DateTime": {
                return DATETIME;
            }
            case "cds.Timestamp": {
                return TIMESTAMP;
            }
            case "cds.String": {
                return STRING;
            }
            case "cds.Binary": {
                return BINARY;
            }
            case "cds.LargeString": {
                return LARGE_STRING;
            }
            case "cds.LargeBinary": {
                return LARGE_BINARY;
            }
            case "cds.hana.SMALLINT": {
                return HANA_SMALLINT;
            }
            case "cds.hana.TINYINT": {
                return HANA_TINYINT;
            }
            case "cds.hana.SMALLDECIMAL": {
                return HANA_SMALLDECIMAL;
            }
            case "cds.hana.REAL": {
                return HANA_REAL;
            }
            case "cds.hana.CHAR": {
                return HANA_CHAR;
            }
            case "cds.hana.NCHAR": {
                return HANA_NCHAR;
            }
            case "cds.hana.VARCHAR": {
                return HANA_VARCHAR;
            }
            case "cds.hana.CLOB": {
                return HANA_CLOB;
            }
            case "cds.hana.BINARY": {
                return HANA_BINARY;
            }
        }
        throw new CdsException("Unknown CDS base type '" + cdsType + "'");
    }

    public static Class<?> cdsJavaMediaType(CdsBaseType cdsType) {
        switch (cdsType) {
            case HANA_CLOB: 
            case LARGE_STRING: {
                return Reader.class;
            }
            case LARGE_BINARY: {
                return InputStream.class;
            }
        }
        throw new CdsException("@Core.MediaType is not supported for type " + (Object)((Object)cdsType));
    }
}

