/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import com.sap.cds.UserContext;
import java.time.Instant;
import java.util.Locale;

public final class SessionContext {
    private final UserContext userContext = UserContext.create();
    private Instant now;
    private Instant validTo;
    private Instant validFrom;

    private SessionContext() {
    }

    public static SessionContext create() {
        return new SessionContext();
    }

    public SessionContext from(SessionContext sessionCtx) {
        this.userContext.from(sessionCtx.getUserContext());
        this.now = sessionCtx.getNow();
        this.validFrom = sessionCtx.getValidFrom();
        this.validTo = sessionCtx.getValidTo();
        return this;
    }

    public SessionContext setUserContext(UserContext userContext) {
        this.userContext.from(userContext);
        return this;
    }

    public SessionContext setNow(Instant now) {
        this.now = now;
        return this;
    }

    public SessionContext setValidTo(Instant validTo) {
        this.validTo = validTo;
        return this;
    }

    public SessionContext setValidFrom(Instant validFrom) {
        this.validFrom = validFrom;
        return this;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public Instant getNow() {
        return this.now != null ? this.now : Instant.now();
    }

    public Instant getValidTo() {
        return this.validTo;
    }

    public Instant getValidFrom() {
        return this.validFrom;
    }

    public Locale getLocale() {
        return this.userContext.getLocale();
    }
}

