/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.cqn;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Limit;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnLimit;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Beta
public interface Modifier {
    default public CqnValue literal(CqnLiteral<?> literal) {
        return literal;
    }

    default public Value<?> ref(ElementRef<?> ref) {
        return ref;
    }

    default public CqnStructuredTypeRef ref(StructuredTypeRef ref) {
        return ref;
    }

    default public Value<?> parameter(String name, String cdsType) {
        return CQL.param(name).type(cdsType);
    }

    default public Value<?> plain(String plain, String cdsType) {
        return CQL.plain(plain).type(cdsType);
    }

    default public Value<?> expression(Value<Number> left, CqnArithmeticExpression.Operator op, Value<Number> right, String cdsType) {
        return CQL.expression(left, op, right).type(cdsType);
    }

    default public Value<?> function(String name, List<Value<?>> args, String cdsType) {
        return CQL.func(name, args).type(cdsType);
    }

    default public Predicate booleanFunction(String name, List<Value<?>> args) {
        return CQL.booleanFunc(name, args);
    }

    default public CqnToken list(List<Value<?>> args) {
        return CQL.list(args);
    }

    default public Predicate comparison(Value<?> lhs, CqnComparisonPredicate.Operator op, Value<?> rhs) {
        return CQL.comparison(lhs, op, rhs);
    }

    @Deprecated
    default public Predicate in(Value<?> value, Collection<Value<?>> list) {
        return CQL.in(value, list);
    }

    default public Predicate in(Value<?> value, CqnValue valueSet) {
        if (valueSet.isList()) {
            return this.in(value, valueSet.asList().values().map(e -> (Value)e).collect(Collectors.toList()));
        }
        return CQL.in(value, valueSet);
    }

    default public Predicate connective(CqnConnectivePredicate.Operator op, List<Predicate> predicates) {
        if (op == CqnConnectivePredicate.Operator.AND) {
            return CQL.and(predicates);
        }
        return CQL.or(predicates);
    }

    default public Predicate negation(Predicate p) {
        return CQL.not(p);
    }

    default public Predicate search(String term) {
        return CQL.search(term);
    }

    default public Predicate exists(Select<?> subQuery) {
        return CQL.exists(subQuery);
    }

    default public Predicate match(StructuredTypeRef ref, Predicate pred, CqnMatchPredicate.Quantifier quantifier) {
        return CQL.match(ref, pred, quantifier);
    }

    @Deprecated
    default public CqnSelectListItem selectListItem(Value<?> value, String alias) {
        return this.selectListValue(value, alias);
    }

    default public CqnSelectListItem selectListValue(Value<?> value, String alias) {
        return value.as(alias);
    }

    default public CqnSelectListItem selectAll() {
        return CQL.star();
    }

    default public CqnSelectListItem inline(StructuredTypeRef ref, List<CqnSelectListItem> items) {
        return CQL.to(ref.segments()).inline((Iterable<Selectable>)items);
    }

    @Deprecated
    default public CqnSelectListItem expand(StructuredTypeRef ref, List<CqnSelectListItem> items, List<CqnSortSpecification> orderBy, CqnLimit limit) {
        Expand<?> expand = CQL.to(ref.segments()).as(ref.alias().orElse(null)).expand((Iterable<Selectable>)items).orderBy(orderBy);
        if (limit != null) {
            expand.limit(limit.top(), limit.skip());
        }
        return this.expand(expand);
    }

    default public CqnSelectListItem expand(Expand<?> expand) {
        return expand;
    }

    default public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
        return items;
    }

    default public Set<String> excluding(Set<String> excluding) {
        return excluding;
    }

    default public boolean distinct(boolean distinct) {
        return distinct;
    }

    default public boolean inlineCount(boolean inlineCount) {
        return inlineCount;
    }

    default public Predicate where(Predicate where) {
        return where;
    }

    default public Predicate search(Predicate search) {
        return search;
    }

    default public Set<String> searchableElements(Set<String> searchableElements) {
        return searchableElements;
    }

    default public List<CqnValue> groupBy(List<CqnValue> list) {
        return list;
    }

    default public Predicate having(Predicate having) {
        return having;
    }

    default public List<CqnSortSpecification> orderBy(List<CqnSortSpecification> sortSpecs) {
        return sortSpecs;
    }

    default public CqnSortSpecification sort(Value<?> value, CqnSortSpecification.Order order) {
        return CQL.sort(value, order);
    }

    @Deprecated
    default public CqnLimit limit(Limit limit) {
        return limit;
    }

    default public Predicate containment(CqnContainmentTest.Position position, CqnValue value, CqnValue substring, boolean caseInsensitive) {
        return CQL.containment(position, value, substring, caseInsensitive);
    }
}

