/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.Result;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public abstract class ResultBuilder {
    private static final Factory factory = Cds4jServiceLoader.load(Factory.class);

    private static ResultBuilder create() {
        return factory.create();
    }

    public static ResultBuilder selectedRows(List<? extends Map<String, ?>> rows) {
        return ResultBuilder.create().rows(rows).rowCount(new long[]{rows.size()});
    }

    public static ResultBuilder insertedRows(List<? extends Map<String, ?>> rows) {
        long[] rowCount = new long[rows.size()];
        Arrays.fill(rowCount, 1L);
        return ResultBuilder.create().rows(rows).rowCount(rowCount);
    }

    public static ResultBuilder updatedRows(long updateCount, Map<String, ?> updateData) {
        return ResultBuilder.create().addUpdatedRows(updateCount, updateData);
    }

    @Deprecated
    public static ResultBuilder updatedRows(int[] updateCount, Map<String, ?> updateData) {
        return ResultBuilder.updatedRows(ResultBuilder.longArray(updateCount), updateData);
    }

    @Deprecated
    public static ResultBuilder updatedRows(long[] updateCount, Map<String, ?> updateData) {
        if (Arrays.stream(updateCount).anyMatch(c -> c > 0L)) {
            ResultBuilder result = ResultBuilder.create();
            for (int i = 0; i < updateCount.length; ++i) {
                result.addUpdatedRows(updateCount[i], updateCount[i] > 0L ? updateData : new HashMap());
            }
            return result;
        }
        return ResultBuilder.create();
    }

    @Deprecated
    public static ResultBuilder updatedRows(int[] updateCount, List<? extends Map<String, ?>> updateData) {
        return ResultBuilder.updatedRows(ResultBuilder.longArray(updateCount), updateData);
    }

    @Deprecated
    public static ResultBuilder updatedRows(long[] updateCount, List<? extends Map<String, ?>> updateData) {
        ResultBuilder result = ResultBuilder.create();
        for (int i = 0; i < updateCount.length; ++i) {
            result.addUpdatedRows(updateCount[i], updateData.get(i));
        }
        return result;
    }

    public static ResultBuilder batchUpdate() {
        return ResultBuilder.create();
    }

    public static ResultBuilder deletedRows(long deleteCount) {
        return ResultBuilder.deletedRows(new long[]{deleteCount});
    }

    public static ResultBuilder deletedRows(int[] deleteCounts) {
        return ResultBuilder.create().rowCount(ResultBuilder.longArray(deleteCounts));
    }

    public static ResultBuilder deletedRows(long[] deleteCounts) {
        return ResultBuilder.create().rowCount(deleteCounts);
    }

    public abstract ResultBuilder entity(CdsEntity var1);

    public abstract ResultBuilder rowType(CdsStructuredType var1);

    public abstract ResultBuilder inlineCount(long var1);

    public abstract ResultBuilder addUpdatedRows(long var1, Map<String, ?> var3);

    public abstract Result result();

    protected abstract ResultBuilder rows(Stream<? extends Map<String, ?>> var1);

    protected ResultBuilder rows(List<? extends Map<String, ?>> rows) {
        return this.rows(rows.stream());
    }

    protected abstract ResultBuilder rowCount(long[] var1);

    private static long[] longArray(int[] updateCount) {
        return Arrays.stream(updateCount).asLongStream().toArray();
    }

    public static interface Factory {
        public ResultBuilder create();
    }
}

