/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql;

import com.sap.cds.ql.CDS;
import com.sap.cds.ql.FilterableStatement;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Searchable;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.StatementBuilder;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Select<T extends StructuredType<?>>
extends StatementBuilder<Select<T>>
implements Source<T>,
CqnSelect,
FilterableStatement<T, Select<T>> {
    public static Select<StructuredType<?>> from(String qualifiedName) {
        return CDS.QL.builder.select(qualifiedName);
    }

    public static Select<StructuredType<?>> from(CqnStructuredTypeRef ref) {
        return CDS.QL.builder.select(ref);
    }

    public static <T extends StructuredType<T>> Select<T> from(StructuredType<T> entity) {
        return CDS.QL.builder.select(entity);
    }

    public static Select<StructuredType<?>> from(String entityName, UnaryOperator<StructuredType<?>> path) {
        return CDS.QL.builder.select(entityName, path);
    }

    public static Select<StructuredType<?>> from(CdsEntity entity) {
        return CDS.QL.builder.select(entity);
    }

    public static Select<StructuredType<?>> from(CqnSelect subquery) {
        return CDS.QL.builder.select(subquery);
    }

    public static Select<StructuredType<?>> from(CdsEntity entity, UnaryOperator<StructuredType<?>> path) {
        return CDS.QL.builder.select(entity, path);
    }

    public static <T extends StructuredType<T>> Select<T> from(Class<T> entity) {
        return CDS.QL.builder.select(entity);
    }

    public static <R extends StructuredType<R>, T extends StructuredType<T>> Select<T> from(Class<R> entity, Function<R, T> path) {
        return CDS.QL.builder.select(entity, path);
    }

    public static Select<StructuredType<?>> copy(CqnSelect select) {
        return (Select)CDS.QL.builder.copy(select);
    }

    public static Select<StructuredType<?>> cqn(String cqnSelect) {
        return CDS.QL.parser.select(cqnSelect);
    }

    public abstract Select<T> distinct();

    public abstract Select<T> inlineCount();

    @SafeVarargs
    public final Select<T> columns(Selectable ... items) {
        return this.columns(Arrays.asList(items));
    }

    @SafeVarargs
    public final Select<T> columns(Function<T, ? extends Selectable> ... items) {
        return this.columns(this.applyFunctions(items));
    }

    public abstract Select<T> columns(List<? extends Selectable> var1);

    public abstract Select<T> columns(Stream<? extends Selectable> var1);

    public abstract Select<T> columns(String ... var1);

    public final Select<T> excluding(String ... qualifiedNames) {
        return this.excluding(Arrays.asList(qualifiedNames));
    }

    @SafeVarargs
    public final Select<T> excluding(Function<T, CqnSelectListValue> ... items) {
        return this.excluding(Arrays.stream(items).map(f -> ((CqnSelectListValue)f.apply(this.getType())).displayName()).collect(Collectors.toList()));
    }

    public abstract Select<T> excluding(Collection<String> var1);

    @Override
    public abstract Select<T> where(Function<T, CqnPredicate> var1);

    @Override
    public abstract Select<T> where(CqnPredicate var1);

    @Override
    public abstract Select<T> matching(Map<String, ?> var1);

    @Override
    public Select<T> byParams(String ... elementRefs) {
        return this.byParams((Collection)Arrays.asList(elementRefs).stream().collect(Collectors.toSet()));
    }

    @Override
    public abstract Select<T> byParams(Collection<String> var1);

    @Override
    public abstract Select<T> byId(Object var1);

    public abstract Select<T> search(String var1);

    public abstract Select<T> search(Function<Searchable, Predicate> var1);

    public abstract Select<T> search(CqnPredicate var1);

    public abstract Select<T> search(Function<Searchable, Predicate> var1, Iterable<String> var2);

    public abstract Select<T> search(String var1, Iterable<String> var2);

    public abstract Select<T> lock(CqnLock.Mode var1, int var2);

    public abstract Select<T> lock(CqnLock.Mode var1);

    public Select<T> lock(int timeout) {
        return this.lock(CqnLock.Mode.EXCLUSIVE, timeout);
    }

    public Select<T> lock() {
        return this.lock(CqnLock.Mode.EXCLUSIVE);
    }

    public final Select<T> groupBy(CqnValue ... dimensions) {
        return this.groupBy(Arrays.asList(dimensions));
    }

    @SafeVarargs
    public final Select<T> groupBy(Function<T, CqnValue> ... dimensions) {
        return this.groupBy(this.applyFunctions(dimensions));
    }

    public abstract Select<T> groupBy(List<? extends CqnValue> var1);

    public abstract Select<T> groupBy(Stream<? extends CqnValue> var1);

    @Deprecated
    public abstract Select<T> groupBy(Collection<CqnSelectListItem> var1);

    public abstract Select<T> groupBy(String ... var1);

    public abstract Select<T> having(CqnPredicate var1);

    public abstract Select<T> having(Function<T, CqnPredicate> var1);

    @SafeVarargs
    public final Select<T> orderBy(Function<T, CqnSortSpecification> ... sortSpecs) {
        return this.orderBy(this.applyFunctions(sortSpecs));
    }

    public final Select<T> orderBy(CqnSortSpecification ... sortSpecs) {
        return this.orderBy(Arrays.asList(sortSpecs));
    }

    public abstract Select<T> orderBy(List<CqnSortSpecification> var1);

    public abstract Select<T> orderBy(String ... var1);

    public Select<T> limit(long top) {
        return this.limit(top, 0L);
    }

    public abstract Select<T> limit(long var1, long var3);

    @Override
    public String toString() {
        return this.toJson();
    }

    @SafeVarargs
    private final <R> List<R> applyFunctions(Function<T, ? extends R> ... functions) {
        return Arrays.stream(functions).map(f -> f.apply(this.getType())).collect(Collectors.toList());
    }

    @Override
    public void accept(CqnVisitor visitor) {
        CqnSelect.super.accept(visitor);
    }
}

