/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect;

import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import java.util.Optional;
import java.util.stream.Stream;

public interface CdsStructuredType
extends CdsType {
    public CdsElement getElement(String var1);

    public Optional<CdsElement> findElement(String var1);

    public CdsElement getAssociation(String var1);

    public Optional<CdsElement> findAssociation(String var1);

    public <S extends CdsStructuredType> S getTargetOf(String var1);

    public Stream<CdsElement> elements();

    default public Stream<CdsElement> keyElements() {
        return this.elements().filter(CdsElement::isKey);
    }

    default public Stream<CdsElement> virtualElements() {
        return this.elements().filter(CdsElement::isVirtual);
    }

    default public Stream<CdsElement> concreteElements() {
        return this.elements().filter(e -> !e.isVirtual());
    }

    default public Stream<CdsElement> nonAssociationElements() {
        return this.elements().filter(e -> !e.getType().isAssociation());
    }

    default public Stream<CdsElement> concreteNonAssociationElements() {
        return this.elements().filter(e -> !e.getType().isAssociation() && !e.isVirtual());
    }

    default public Stream<CdsElement> associations() {
        return this.elementsOfType(CdsAssociationType.class);
    }

    default public Stream<CdsElement> compositions() {
        return this.associations().filter(a -> a.getType().as(CdsAssociationType.class).isComposition());
    }

    default public <T extends CdsType> Stream<CdsElement> elementsOfType(Class<T> type) {
        return this.elements().filter(e -> type.isAssignableFrom(e.getType().getClass()));
    }

    @Deprecated
    default public boolean isInlineDefined() {
        return this.isAnonymous();
    }

    default public boolean isAnonymous() {
        return this.getQualifiedName() == null || this.getQualifiedName().isEmpty();
    }

    @Override
    default public boolean isStructured() {
        return true;
    }

    @Override
    default public void accept(CdsVisitor visitor) {
        this.elements().forEach(e -> e.accept(visitor));
        visitor.visit(this);
    }
}

