/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import com.google.common.collect.ImmutableList;
import com.sap.cds.CdsException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public final class Cds4jServiceLoader {
    private static final Map<String, Class<?>> implementations = new ConcurrentHashMap();

    private Cds4jServiceLoader() {
    }

    public static <T> T load(Class<T> clazz) {
        Class impl = implementations.computeIfAbsent(clazz.getCanonicalName(), c -> Cds4jServiceLoader.findImpl(clazz));
        try {
            return impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new CdsException("Failed to instantiate " + impl.getCanonicalName(), e);
        }
    }

    private static <T> Class<T> findImpl(Class<T> clazz) {
        Iterator<T> implClasses = ServiceLoader.load(clazz).iterator();
        if (implClasses.hasNext()) {
            return implClasses.next().getClass();
        }
        throw new CdsException("Cannot find implementation of " + clazz.getCanonicalName());
    }

    public static <T> Optional<T> find(Class<T> clazz) {
        try {
            return Optional.of(Cds4jServiceLoader.load(clazz));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> Collection<T> loadAll(Class<T> clazz) {
        return ImmutableList.copyOf(ServiceLoader.load(clazz).iterator());
    }
}

