/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

/**
 * Thrown by the runtime when {@link Result#single()} is executed and the result
 * contains more than one row. This exception will not cause the current
 * transaction to be marked for rollback.
 */
public class NonUniqueResultException extends CdsException {

	private static final long serialVersionUID = 1L;

	public NonUniqueResultException(String message, Throwable cause) {
		super(message, cause);
	}

	public NonUniqueResultException(String message) {
		super(message);
	}

}
