/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql;

import com.sap.cds.reflect.CdsModel;

public interface CqnParser {

	static CqnParser instance() {
		return CDS.QL.parser;
	}

	Select<StructuredType<?>> select(String cqn);

	Insert insert(CdsModel model, String cqn);

	Upsert upsert(CdsModel model, String cqn);

	Update<StructuredType<?>> update(CdsModel model, String cqn);

	Delete<StructuredType<?>> delete(String cqn);

}
