/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import com.sap.cds.ql.cqn.CqnPredicate;

public interface Predicate extends CqnPredicate {

	/**
	 * Creates a conjunction of this predicate with other predicates
	 * 
	 * @param other other predicate to connect this predicate with
	 * @param more  more predicates to connect this predicate with
	 * 
	 * @return the conjunction
	 */
	Predicate and(CqnPredicate other, CqnPredicate... more);

	/**
	 * Creates a disjunction of this predicate with other predicates
	 * 
	 * @param other other predicate to connect this predicate with
	 * @param more  more predicates to connect this predicate with
	 * 
	 * @return the disjunction
	 */
	Predicate or(CqnPredicate other, CqnPredicate... more);

	/**
	 * Negates this predicate
	 * 
	 * @return the negated predicate
	 */
	Predicate not();

}
