/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

/**
 * The {@code between} predicate that tests if the {@link #value()} is within a
 * closed interval with given bounds of {@link #low()} and {@link #high()}.
 */
public interface CqnBetweenPredicate extends CqnPredicate {

	CqnValue value();

	CqnValue low();

	CqnValue high();

	@Override
	default void accept(CqnVisitor visitor) {
		value().accept(visitor);
		low().accept(visitor);
		high().accept(visitor);
		visitor.visit(this);
	}
}
