/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import com.google.common.annotations.Beta;

public interface CqnUpdate extends CqnFilterableStatement {

	/**
	 * The data to be updated by this statement.
	 * 
	 * @return a reference to this statement's update data
	 */
	Map<String, Object> data();

	/**
	 * The entries to be updated by this statement.
	 * 
	 * @return a reference to this statement's update entries
	 */
	List<Map<String, Object>> entries();

	/**
	 * The setters of this statement.
	 * 
	 * @return a reference to this statement's update setters
	 */
	@Beta
	Map<String, CqnValue> setters();

	/**
	 * The elements to be updated by this statement.
	 * 
	 * @return a stream of the elements to be updated
	 */
	Stream<String> elements();

	@Override
	default boolean isUpdate() {
		return true;
	}

	@Override
	default CqnUpdate asUpdate() {
		return this;
	}
}
