/*******************************************************************
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn.transformation;

import java.util.List;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnSelectListValue;

/**
 * Transformation that adds additional computed elements to the input set
 */
@Beta
public interface CqnComputeTransformation extends CqnTransformation {

	/**
	 * Returns the additional computed elements specified as select list values
	 * 
	 * @return the additional elements
	 */
	List<CqnSelectListValue> computedItems();

	@Override
	default Kind kind() {
		return Kind.COMPUTE;
	}
}
