/************************************************************************
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.reflect;

/**
 * Indicates a missing {@link CdsElement} in {@link CdsDefinition}.
 */
public class CdsElementNotFoundException extends CdsReflectiveOperationException {

	private static final long serialVersionUID = 1L;
	private final transient CdsDefinition definition;
	private final String path;

	public CdsElementNotFoundException(String path, CdsDefinition definition) {
		super("No element with %s '%s' in '%s'".formatted(path.contains(".") ? "path" : "name", path,
				definition.getQualifiedName()));
		this.path = path;
		this.definition = definition;
	}

	/**
	 * Get the missing element name or path
	 * 
	 * @return element name or path
	 */
	public String getElementName() {
		return path;
	}

	/**
	 * Get the definition for which the element was requested
	 * 
	 * @return definition
	 */
	public CdsDefinition getDefinition() {
		return definition;
	}
}
