/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.transaction;

public interface TransactionManager {

	/**
	 * Checks if there is an active transaction associated with the current thread
	 * 
	 * @return <code>true</code> if there is an active transaction;
	 *         <code>false</code> otherwise
	 */
	boolean isActive();

	/**
	 * If the current thread is associated with an active transaction it is set in
	 * rollback only mode
	 */
	void setRollbackOnly();

}
