/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds;

import com.sap.cds.ql.CdsDataException;
import com.sap.cds.reflect.CdsElement;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class NotNullConstraintException
extends CdsDataException {
    private static final long serialVersionUID = 1L;
    private final transient List<CdsElement> nonNullableElements;

    public NotNullConstraintException(List<CdsElement> nonNullableElements, Exception ex) {
        super(String.format("Constraint violated: %s must not be NULL.", NotNullConstraintException.stringify(nonNullableElements)), ex);
        this.nonNullableElements = Collections.unmodifiableList(nonNullableElements);
    }

    public List<String> getElementNames() {
        return NotNullConstraintException.names(this.nonNullableElements).collect(Collectors.toList());
    }

    public String getEntityName() {
        return this.nonNullableElements.get(0).getDeclaringType().getQualifiedName();
    }

    private static String stringify(List<CdsElement> nonNullableElements) {
        return NotNullConstraintException.names(nonNullableElements).map(e -> "'" + e + "'").collect(Collectors.joining(", "));
    }

    private static Stream<String> names(List<CdsElement> nonNullableElements) {
        return nonNullableElements.stream().map(CdsElement::getQualifiedName);
    }
}

