/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

import com.sap.cds.reflect.CdsDefinition;

/**
 * Indicates that pessimistic locking conflict occurs when querying data from
 * data source that does not result in transaction rollback.
 */
public class CdsLockTimeoutException extends CdsException {
	private static final long serialVersionUID = 1L;

	private final transient CdsDefinition definition;

	public CdsLockTimeoutException(CdsDefinition definition) {
		super(String.format("Lock timeout for entity '%s'", definition.getQualifiedName()));
		this.definition = definition;
	}

	/**
	 * Get the definition for which the lock timeout occurred
	 * 
	 * @return definition
	 */
	public CdsDefinition getDefinition() {
		return definition;
	}
}
