/************************************************************************
 * © 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql;

import com.sap.cds.ql.cqn.CqnSortSpecification;

public interface Orderable {

	/**
	 * Ascending order with null values before non-null values.
	 */
	CqnSortSpecification asc();

	/**
	 * Ascending order with null values after non-null values.
	 */
	CqnSortSpecification ascNullsLast();

	/**
	 * Descending order with null values after non-null values.
	 */
	CqnSortSpecification desc();

	/**
	 * Descending order with null values before non-null values.
	 */
	CqnSortSpecification descNullsFirst();
}
