/*******************************************************************
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql;

import java.util.Map;

public interface Statement<T> {

	/**
	 * Sets the hints for the statement.
	 *
	 * @param hints the hint map
	 * @return this statement
	 */
	T hints(Map<String, Object> hints);

	/**
	 * Adds a hint to the statement.
	 *
	 * @param name the hint name
	 * @param value the hint value 
	 * @return this statement
	 */
	T hint(String name, Object value);

}
