/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

public interface CqnContainmentTest extends CqnPredicate, CqnFunc {
	Position position();

	CqnValue value();

	CqnValue term();

	boolean caseInsensitive();

	@Override
	default void accept(CqnVisitor visitor) {
		value().accept(visitor);
		term().accept(visitor);

		visitor.visit(this);
	}

	enum Position {
		START("startsWith"), END("endsWith"), ANY("contains");

		private final String func;

		Position(String func) {
			this.func = func;
		}

		public String func() {
			return func;
		}
	}

}
