/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

public interface CqnParameter extends CqnValue {

	/**
	 * Returns the name of this parameter
	 *
	 * @return the name of this parameter
	 */
	String name();

	@Override
	default CqnParameter asParameter() {
		return this;
	}

	@Override
	default boolean isParameter() {
		return true;
	}

	/**
	 * Returns {@code true} if this is a positional parameter.
	 *
	 * @return {@code true} if this is a positional parameter, otherwise
	 *         {@code false}
	 */
	default boolean isPositional() {
		return "?".equals(name());
	}

	default void accept(CqnVisitor visitor) {
		visitor.visit(this);
	}

}
