/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

import com.sap.cds.ql.Selectable;

public interface CqnSelectListItem extends Selectable, CqnToken {

	default CqnToken token() {
		return this;
	}

	default boolean isValue() {
		return false;
	}

	default boolean isRef() {
		return false;
	}

	default boolean isSelectList() {
		return false;
	}

	default boolean isExpand() {
		return false;
	}

	default boolean isStar() {
		return false;
	}

	default CqnSelectListValue asValue() {
		throw new ClassCastException("Cannot cast to CqnSelectListValue");
	}

	default Stream<CqnSelectListValue> ofValue() {
		return Stream.empty();
	}

	default CqnElementRef asRef() {
		throw new UnsupportedOperationException("Select list item is not an element ref");
	}

	default Stream<CqnElementRef> ofRef() {
		return Stream.empty();
	}

	default CqnSelectList asSelectList() {
		throw new ClassCastException("Cannot cast to CqnSelectList");
	}

	default CqnExpand asExpand() {
		throw new ClassCastException("Cannot cast to CqnExpand");
	}

	default Stream<CqnSelectListItem> unfold(
			Function<List<? extends CqnReference.Segment>, Stream<String>> pathToElements) {
		return Stream.of(this);
	}

}
