/**************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Locale;

public interface CqnSortSpecification extends CqnToken {

	CqnValue value();

	Order order();

	/**
	 * The sort order of a {@link CqnSortSpecification}
	 */
	public enum Order {
		/**
		 * Ascending order with null values before non-null values.
		 */
		ASC("asc", "first"),
		/**
		 * Descending order with null values after non-null values.
		 */
		DESC("desc", "last"),
		/**
		 * Ascending order with null values after non-null values.
		 */
		ASC_NULLS_LAST("asc", "last"),
		/**
		 * Descending order with null values before non-null values.
		 */
		DESC_NULLS_FIRST("desc", "first");

		/**
		 * The order (asc or desc)
		 */
		public final String sort;
		/**
		 * The order of null values (first or last)
		 */
		public final String nulls;

		public static Order valueOf(String sort, String nulls) {
			if (DESC.sort.equalsIgnoreCase(sort)) {
				if (DESC_NULLS_FIRST.nulls.equalsIgnoreCase(nulls)) {
					return DESC_NULLS_FIRST;
				}
				return DESC;
			} else if (ASC_NULLS_LAST.nulls.equalsIgnoreCase(nulls)) {
				return ASC_NULLS_LAST;
			}
			return ASC;
		}

		private Order(String sort, String nulls) {
			this.sort = sort;
			this.nulls = nulls;
		}

		@Override
		public String toString() {
			return name().toLowerCase(Locale.US);
		}
	}

	default void accept(CqnVisitor visitor) {
		value().accept(visitor);

		visitor.visit(this);
	}
}
