/*******************************************************************
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Map;

public interface CqnStructuredLiteral extends CqnLiteral<Map<String, Object>> {

	Map<String, Object> value();

	default void accept(CqnVisitor visitor) {
		visitor.visit(this);
	}

	@Override
	default boolean isStructured() {
		return true;
	}

}
