/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Optional;

public interface CqnStructuredTypeRef extends CqnReference, CqnSource {

	@Override
	default boolean isRef() {
		return true;
	}

	@Override
	default CqnStructuredTypeRef asRef() {
		return this;
	}

	Optional<String> alias();

	@Override
	default void accept(CqnVisitor visitor) {
		visitor.visit(this);
	}

}
