/**************************************************************************
 * (C) 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.reflect;

import java.util.Optional;

public interface CdsAction extends CdsOperation {

	/**
	 * Returns an {@link Optional} wrapping the {@link CdsType} of this
	 * {@code CdsAction}.
	 * 
	 * @return an {@code Optional} describing the {@code CdsType} of this
	 *         definition, or an empty {@code Optional} if the action does not have
	 *         a return type
	 */
	Optional<CdsType> returnType();

	@Override
	default CdsKind getKind() {
		return CdsKind.ACTION;
	}

	@Override
	default void accept(CdsVisitor visitor) {
		parameters().forEach(e -> e.accept(visitor));

		visitor.visit(this);
	}

}
