/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.reflect;

/**
 * Indicates a missing definition {@link CdsDefinition} in CDS model.
 */
public class CdsDefinitionNotFoundException extends CdsReflectiveOperationException {

	private static final long serialVersionUID = 1L;
	private final String qualifiedName;
	private final CdsKind kind;

	public CdsDefinitionNotFoundException(CdsKind kind, String qualifiedName) {
		super(String.format("Cannot find %s '%s'", kind, qualifiedName));
		this.qualifiedName = qualifiedName;
		this.kind = kind;
	}

	/**
	 * Get qualified name of the definition
	 * 
	 * @return qualified name of the definition
	 */
	public String getQualifiedName() {
		return qualifiedName;
	}

	/**
	 * Get the definition kind
	 * 
	 * @return definition kind {@link CdsKind}
	 */
	public CdsKind getKind() {
		return kind;
	}
}
