/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds;

/**
 * This exception is thrown when the client is unable to communicate with the
 * remote system, such as data store or MTX "sidecar".
 */
public class CdsCommunicationException extends CdsException {

	private static final long serialVersionUID = 1L;
	private final int httpStatusCode;

	public CdsCommunicationException(Throwable e) {
		this(e, -1);
	}

	public CdsCommunicationException(String message) {
		this(message, -1);
	}

	public CdsCommunicationException(String message, Throwable e) {
		this(message, e, -1);
	}

	public CdsCommunicationException(Throwable e, int httpStatusCode) {
		super(e);
		this.httpStatusCode = httpStatusCode;
	}

	public CdsCommunicationException(String message, int httpStatusCode) {
		super(message);
		this.httpStatusCode = httpStatusCode;
	}

	public CdsCommunicationException(String message, Throwable e, int httpStatusCode) {
		super(message, e);
		this.httpStatusCode = httpStatusCode;
	}

	public int getHttpStatusCode() {
		return httpStatusCode;
	}
}
