/************************************************************************
 * © 2020-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds;

import java.time.Instant;
import java.util.Locale;
import java.util.TimeZone;

public final class SessionContext {

	private final UserContext userContext;
	private Instant now;
	private Instant validTo;
	private Instant validFrom;

	private SessionContext() {
		userContext = UserContext.create();
	}

	public static SessionContext create() {
		return new SessionContext();
	}

	public SessionContext from(SessionContext sessionCtx) {
		this.userContext.from(sessionCtx.getUserContext());
		this.now = sessionCtx.getNow();
		this.validFrom = sessionCtx.getValidFrom();
		this.validTo = sessionCtx.getValidTo();
		return this;
	}

	public SessionContext setUserContext(UserContext userContext) {
		this.userContext.from(userContext);
		return this;
	}

	public SessionContext setNow(Instant now) {
		this.now = now;
		return this;
	}

	public SessionContext setValidTo(Instant validTo) {
		this.validTo = validTo;
		return this;
	}

	public SessionContext setValidFrom(Instant validFrom) {
		this.validFrom = validFrom;
		return this;
	}

	public UserContext getUserContext() {
		return userContext;
	}

	public Instant getNow() {
		return now != null ? now : Instant.now();
	}

	public Instant getValidTo() {
		return validTo;
	}

	public Instant getValidFrom() {
		return validFrom;
	}

	public Locale getLocale() {
		return userContext.getLocale();
	}

	public TimeZone getTimeZone() {
		return userContext.getTimeZone();
	}
}
