/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql;

import com.sap.cds.ql.cqn.CqnElementRef;

public interface ElementRef<T> extends Value<T>, CqnElementRef {

	/**
	 * Sets an alias.
	 * 
	 * @param alias the alias
	 * @return a ref with the given alias. Can be a new ref if this ref is immutable
	 */
	@Override
	ElementRef<T> as(String alias);

	/**
	 * Sets the type.
	 * 
	 * @param type the type name
	 * @return a ref with the given type. Can be a new ref if this ref is immutable
	 */
	@Override
	<U> Value<U> type(String type);

}
