/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

public interface CqnComparisonPredicate extends CqnPredicate {

	CqnValue left();

	CqnValue right();

	Operator operator();

	@Override
	default void accept(CqnVisitor visitor) {
		left().accept(visitor);
		right().accept(visitor);

		visitor.visit(this);
	}

	enum Operator {
		EQ("="), GT(">"), LT("<"), GE(">="), LE("<="), NE("<>"), IS("is"), IS_NOT("is not");

		public final String symbol;

		private Operator(String op) {
			this.symbol = op;
		}
	}

}
