/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;

/**
 * A predicate that connects multiple {@link #predicates() predicates} with a
 * logical {@link #operator() operator} ({@code AND}/{@code OR}).
 */
public interface CqnConnectivePredicate extends CqnPredicate {

	/**
	 * @return the connected predicates
	 */
	List<CqnPredicate> predicates();

	/**
	 * @return the logical operator ({@code AND}/{@code OR}) of the connective
	 */
	Operator operator();

	@Override
	default void accept(CqnVisitor visitor) {
		predicates().forEach(p -> p.accept(visitor));

		visitor.visit(this);
	}

	enum Operator {
		AND("and"), OR("or");

		public final String symbol;

		private Operator(String op) {
			this.symbol = op;
		}
	}

}
