/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.ql.cqn;

import java.util.Optional;

/**
 * Predicate that tests whether any|all elements of an entity set match a given
 * condition
 */
public interface CqnMatchPredicate extends CqnPredicate {

	/**
	 * The referenced entity set
	 * 
	 * @return the referenced entity set
	 */
	CqnStructuredTypeRef ref();

	/**
	 * The condition to test for
	 * 
	 * @return the condition to test for
	 */
	Optional<CqnPredicate> predicate();

	/**
	 * Whether all or any elements need to fulfill the condition
	 * 
	 * @return whether all or any elements need to fulfill the condition
	 */
	Quantifier quantifier();

	/**
	 * Dispatches the handling of this {@code CqnMatchPredicate} to a given visitor.
	 * 
	 * Neither the {@code ref} nor filter {@code predicate} is traversed.
	 * 
	 * @param visitor the {@link CqnVisitor}
	 */
	@Override
	default void accept(CqnVisitor visitor) {
		visitor.visit(this);
	}

	public enum Quantifier {
		ALL, ANY
	}

}
