/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.ql.cqn;

import java.util.List;
import java.util.Map;

public interface CqnUpsert extends CqnXsert {

	/**
	 * The entries to be upserted by this statement.
	 * 
	 * @return a reference to the upsert statement's entries
	 */
	@Override
	List<Map<String, Object>> entries();

	@Override
	default boolean isUpsert() {
		return true;
	}

	@Override
	default CqnUpsert asUpsert() {
		return this;
	}

}
